<?php

namespace App;

class PostsShares extends Eloquent {

	protected $table = 'posts_shares';
	public $timestamps = true;
	protected $fillable = array('post_id', 'posted_by', 'shared_by');
	protected $visible = array('post_id', 'posted_by', 'shared_by');

	public function post()
	{
		return $this->belongsTo('App\Posts', 'post_id');
	}

	public function postedBy()
	{
		return $this->belongsTo('App\User', 'posted_by');
	}

	public function sharedBy()
	{
		return $this->belongsTo('App\User', 'shared_by');
	}

}