<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id', 'name', 'email', 'password');
	protected $visible = array('id', 'name', 'email');

	public function getPosts()
	{
		return $this->hasMany('App\Posts', 'posted_by');
	}

	public function getNews()
	{
		return $this->hasMany('App\News', 'posted_by');
	}

	public function getEvents()
	{
		return $this->hasMany('App\Events', 'posted_by');
	}

	public function getFriends()
	{
		return $this->hasMany('App\Relationship', 'user_id');
	}

}