<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('posted_by')->unsigned();
			$table->string('contents')->nullable();
			$table->string('image')->nullable();
			$table->string('videos')->nullable();
			$table->bigInteger('like_count')->default('0');
			$table->bigInteger('comment_count')->default('0');
			$table->bigInteger('share_count')->default('0');
			$table->enum('type', array('Self', 'Shared'))->nullable();
			$table->bigInteger('shared_by')->unsigned();
			$table->enum('status', array('Active', 'Inactive', 'Deleted'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}