<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('branch_id')->unsigned()->nullable();
			$table->enum('status', array('live', 'queue'))->nullable();
			$table->date('date')->nullable();
			$table->time('time')->nullable();
			$table->string('discount')->nullable();
			$table->integer('total_price')->nullable();
			$table->integer('main_price')->nullable();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}