<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesPermissionsTable extends Migration {

	public function up()
	{
		Schema::create('roles_permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('permisson_id')->unsigned()->nullable();
			$table->string('role_id')->unique()->nullable();
			$table->integer('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('roles_permissions');
	}
}