<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesUsersTable extends Migration {

	public function up()
	{
		Schema::create('roles_users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('role_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('roles_users');
	}
}