<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RoleUser extends Eloquent {

	protected $table = 'roles_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('role_id', 'user_id', 'created_by', 'updated_by');

	public function users()
	{
		return $this->hasMany('App\Models\User', 'user_id');
	}

	public function roles()
	{
		return $this->hasMany('App\Models\Role', 'role_id');
	}

}