<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceReservation extends Eloquent {

	protected $table = 'service_reservation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('reservation_id', 'service_id', 'created_by', 'updated_by');

	public function reservations()
	{
		return $this->hasMany('App\Models\Reservation', 'reservation_id');
	}

	public function services()
	{
		return $this->hasMany('App\Models\Service', 'service_id');
	}

}