<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdrecProductTable extends Migration {

	public function up()
	{
		Schema::create('adrec_product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->index();
			$table->integer('company_id')->index();
			$table->json('category')->nullable()->index();
			$table->json('brand')->nullable()->index();
			$table->json('personality')->nullable()->index();
			$table->string('values', 500)->nullable()->index();
			$table->json('audience')->nullable()->index();
			$table->json('guideline')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('adrec_product');
	}
}