<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->hasMany('App\Models\User');
	}

	public function matches()
	{
		return $this->hasMany('App\Models\Match');
	}

	public function players()
	{
		return $this->hasMany('App\Models\Player');
	}

	public function games()
	{
		return $this->hasMany('App\Models\Game');
	}

	public function images()
	{
		return $this->hasManyThrough('App\Models\Image', 'App\Models\Match');
	}

}