<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Match extends Eloquent {

	protected $table = 'match';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function game()
	{
		return $this->hasOne('App\Models\Game');
	}

	public function players()
	{
		return $this->hasMany('App\Models\Player');
	}

	public function group()
	{
		return $this->belongsTo('App\Models\Group');
	}

	public function location()
	{
		return $this->hasOne('App\Models\Location');
	}

	public function notes()
	{
		return $this->hasMany('App\Models\MatchNote');
	}

}