<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('image_url');
			$table->decimal('price');
			$table->decimal('offer_price');
			$table->integer('prep_time')->unsigned();
			$table->string('description');
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}