<?php

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;

	public function district()
	{
		return $this->hasOne('District');
	}

	public function categories()
	{
		return $this->hasMany('Category');
	}

	public function reviewers()
	{
		return $this->belongsToMany('Customer');
	}

	public function promotions()
	{
		return $this->hasMany('Offer');
	}

	public function notifications()
	{
		return $this->morphMany('Notification', 'notifiable');
	}

	public function accountPayable()
	{
		return $this->hasOne('AccountPayable');
	}

	public function products()
	{
		return $this->hasMany('Product');
	}

}