<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('restaurant', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_restaurant', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_restaurant', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurant')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment_method')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('order_state')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('cart')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cuisine_restaurant', function(Blueprint $table) {
			$table->foreign('cuisine_id')->references('id')->on('cuisine')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cuisine_restaurant', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurant')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('district')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_notification', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_notification', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notification')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('promotion_restaurant', function(Blueprint $table) {
			$table->foreign('promotion_id')->references('id')->on('promotion')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('promotion_restaurant', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurant')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->foreign('promotion_id')->references('id')->on('promotion')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('contact_us', function(Blueprint $table) {
			$table->foreign('message_type')->references('id')->on('message_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('restaurant', function(Blueprint $table) {
			$table->dropForeign('restaurant_city_id_foreign');
		});
		Schema::table('customer', function(Blueprint $table) {
			$table->dropForeign('customer_city_id_foreign');
		});
		Schema::table('customer_restaurant', function(Blueprint $table) {
			$table->dropForeign('customer_restaurant_customer_id_foreign');
		});
		Schema::table('customer_restaurant', function(Blueprint $table) {
			$table->dropForeign('customer_restaurant_restaurant_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_customer_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_order_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_product_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_customer_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_payment_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_state_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_cart_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_product_id_foreign');
		});
		Schema::table('cuisine_restaurant', function(Blueprint $table) {
			$table->dropForeign('cuisine_restaurant_cuisine_id_foreign');
		});
		Schema::table('cuisine_restaurant', function(Blueprint $table) {
			$table->dropForeign('cuisine_restaurant_restaurant_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_district_id_foreign');
		});
		Schema::table('customer_notification', function(Blueprint $table) {
			$table->dropForeign('customer_notification_customer_id_foreign');
		});
		Schema::table('customer_notification', function(Blueprint $table) {
			$table->dropForeign('customer_notification_notification_id_foreign');
		});
		Schema::table('promotion_restaurant', function(Blueprint $table) {
			$table->dropForeign('promotion_restaurant_promotion_id_foreign');
		});
		Schema::table('promotion_restaurant', function(Blueprint $table) {
			$table->dropForeign('promotion_restaurant_restaurant_id_foreign');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->dropForeign('customer_promotion_customer_id_foreign');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->dropForeign('customer_promotion_promotion_id_foreign');
		});
		Schema::table('customer_promotion', function(Blueprint $table) {
			$table->dropForeign('customer_promotion_order_id_foreign');
		});
		Schema::table('contact_us', function(Blueprint $table) {
			$table->dropForeign('contact_us_message_type_foreign');
		});
	}
}