<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    public function district()
    {
        return $this->hasOne('District');
    }

    public function reviewedRestaurants()
    {
        return $this->hasMany('Restaurant');
    }

    public function cart()
    {
        return $this->hasOne('Cart');
    }

    public function notifiable()
    {
        return $this->morphMany('Notification', 'notifiable');
    }

}