<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('training_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->float('rating', 3,2);
			$table->string('review_text', 255);
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}