<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('training_schedules', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('training_schedules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons_section', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('supporting_materials', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('e_certificates', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('e_certificates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('id')->on('conversations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pre_tests', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_tests', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('training_schedules', function(Blueprint $table) {
			$table->dropForeign('training_schedules_training_id_foreign');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->dropForeign('enrolled_training_user_id_foreign');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->dropForeign('enrolled_training_schedule_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_training_id_foreign');
		});
		Schema::table('lessons_section', function(Blueprint $table) {
			$table->dropForeign('lessons_section_lesson_id_foreign');
		});
		Schema::table('supporting_materials', function(Blueprint $table) {
			$table->dropForeign('supporting_materials_lesson_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_training_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_training_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_user_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_payment_id_foreign');
		});
		Schema::table('e_certificates', function(Blueprint $table) {
			$table->dropForeign('e_certificates_training_id_foreign');
		});
		Schema::table('e_certificates', function(Blueprint $table) {
			$table->dropForeign('e_certificates_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_training_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_user_id_foreign');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_author_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_conversation_id_foreign');
		});
		Schema::table('pre_tests', function(Blueprint $table) {
			$table->dropForeign('pre_tests_training_id_foreign');
		});
		Schema::table('post_tests', function(Blueprint $table) {
			$table->dropForeign('post_tests_training_id_foreign');
		});
	}
}