<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function enrolled_training()
    {
        return $this->hasMany('Modules\Training\Entities\EnrolledTraining', 'user_id');
    }

    public function payment()
    {
        return $this->hasMany('Modules\Training\Entities\Payment', 'user_id');
    }

    public function enrollment()
    {
        return $this->hasMany('Modules\Training\Entities\Enrollment', 'user_id');
    }

    public function e_certificate()
    {
        return $this->hasMany('Modules\Training\Entities\ECertificate', 'user_id');
    }

    public function training()
    {
        return $this->hasMany('Modules\Training\Entities\Training', 'creator_id');
    }

    public function review()
    {
        return $this->hasMany('Modules\Training\Entities\Review', 'user_id');
    }

    public function conversation()
    {
        return $this->hasMany('Modules\Training\Entities\Conversation', 'user_id');
    }

    public function author()
    {
        return $this->hasMany('Modules\Training\Entities\Conversation', 'author_id');
    }

}