<?php

namespace Api;

class Container extends Eloquent {

	protected $table = 'container';
	public $timestamps = true;
	protected $fillable = array('container_number', 'is_fcl', 'client_id', 'transporting_company_id', 'from_harbor_id', 'to_harbor_id', 'total_cost', 'status', 'shipping_date', 'arrival_date', 'collected_fund', 'shipping_yard', 'labor', 'tax', 'other_fees');

	public function FromHarbor()
	{
		return $this->belongsTo('Harbor', 'from_harbor_id');
	}

	public function ToHarbor()
	{
		return $this->belongsTo('Harbor', 'to_harbor_id');
	}

	public function TransportingCompany()
	{
		return $this->belongsTo('TransportingCompany', 'transporting_company_id');
	}

	public function Client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}