<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('subject', 191);
			$table->string('from', 191);
			$table->string('to', 191);
			$table->longText('content');
			$table->timestamps();
			$table->string('label', 191);
			$table->string('fold', 191);
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}