<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 191);
			$table->text('short_text')->nullable();
			$table->longText('content');
			$table->string('thumbnail', 191);
			$table->string('status', 100);
			$table->timestamps();
			$table->string('keywords', 100);
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}