<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetasTable extends Migration {

	public function up()
	{
		Schema::create('metas', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('firstname', 191);
			$table->string('lastname', 191)->nullable();
			$table->string('avatar', 191);
			$table->string('banner');
			$table->text('description');
			$table->string('address', 191);
			$table->string('gender', 191);
			$table->string('company', 191);
			$table->text('favorite');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('metas');
	}
}