<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Posts extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'slug', 'content', 'thumbnail', 'description');

    public function user()
    {
        return $this->belongsTo('Users');
    }

    public function category()
    {
        return $this->belongsTo('Categories');
    }

}