<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Admin extends Eloquent {

	protected $table = 'admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function areas()
	{
		return $this->hasMany('App\Models\Area');
	}

	public function specializations()
	{
		return $this->hasMany('App\Models\Specialization');
	}

	public function users()
	{
		return $this->hasMany('App\Models\User');
	}

	public function media()
	{
		return $this->hasOne('App\Models\Media');
	}

	public function role()
	{
		return $this->belongsTo('App\Models\Role');
	}

}