<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function permissions()
	{
		return $this->belongsToMany('App\Models\Permission');
	}

	public function admins()
	{
		return $this->hasMany('App\Models\Admin');
	}

}