<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Professionals extends Model 
{

    protected $table = 'professionals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userDetail()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function experiance()
    {
        return $this->hasMany('Experience', 'pro_id');
    }

    public function categoryDetail()
    {
        return $this->hasOne('Category', 'cat_id');
    }

}