<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 100);
			$table->string('qualification', 100)->nullable();
			$table->string('designation', 100);
			$table->string('email', 100)->nullable();
			$table->integer('org_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}