<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessionalsTable extends Migration {

	public function up()
	{
		Schema::create('professionals', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('is_verified')->nullable();
			$table->integer('email_status')->nullable();
			$table->integer('mobile_status')->nullable();
			$table->text('description')->nullable();
			$table->integer('profession')->nullable();
			$table->string('license_number', 100)->nullable();
			$table->string('qualification', 100)->nullable();
			$table->string('facebook', 100);
			$table->string('twitter', 100)->nullable();
			$table->string('linkedin', 100)->nullable();
			$table->integer('sub_category_id')->unsigned()->nullable();
			$table->string('certificate', 100);
			$table->string('certificate_status')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('cat_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('professionals');
	}
}