<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWaitPointsTable extends Migration {

	public function up()
	{
		Schema::create('wait_points', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('active');
			$table->float('location_lat');
			$table->float('location_long');
			$table->integer('driver_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('wait_points');
	}
}