<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DrivePoint extends Eloquent {

	protected $table = 'drive_points';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function DrivePath()
	{
		return $this->belongsTo('DrivePath');
	}

	public function WayPoint()
	{
		return $this->hasOne('Waypoint');
	}

	public function Destination()
	{
		return $this->hasOne('Destination');
	}

}