<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Mentor extends Model 
{

    protected $table = 'mentors';
    public $timestamps = true;

    public function tag()
    {
        return $this->belongsTo('Tag', 'tag_id');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function socialLinks()
    {
        return $this->hasMany('SocialLinks');
    }

    public function packages()
    {
        return $this->hasMany('Package');
    }

}