<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMentorsTable extends Migration {

	public function up()
	{
		Schema::create('mentors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tag_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('name')->nullable();
			$table->string('slug');
			$table->string('bio');
			$table->string('experience')->nullable();
			$table->string('short_description')->nullable();
			$table->string('description')->nullable();
			$table->string('image')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('mentors');
	}
}