<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationsTable extends Migration {

	public function up()
	{
		Schema::create('educations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('resume_id')->unsigned()->index();
			$table->bigInteger('major_id')->unsigned();
			$table->bigInteger('school_id')->unsigned();
			$table->json('title');
			$table->float('degree')->nullable();
			$table->tinyInteger('position')->unsigned();
			$table->json('description')->nullable();
			$table->json('activities_and_societies')->nullable();
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->timestamp('start_at');
			$table->timestamp('end_at')->nullable();
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('educations');
	}
}