<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillablesTable extends Migration {

	public function up()
	{
		Schema::create('skillables', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('skill_id')->unsigned();
			$table->bigInteger('resume_id')->unsigned();
			$table->enum('type', array('skill', 'interest'));
			$table->enum('level', array('unknown', 'beginner', 'intermediate', 'advanced'));
			$table->tinyInteger('position')->unsigned();
			$table->timestamp('created_at');
			$table->string('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('skillables');
	}
}