<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactTable extends Migration {

	public function up()
	{
		Schema::create('contact', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('from_user_id')->unsigned();
			$table->string('from_name', 255);
			$table->string('from_email', 255);
			$table->text('message');
			$table->timestamps();
			$table->timestamp('read_at')->nullable();
			$table->text('internal_notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contact');
	}
}