<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('lunch_id')->unsigned()->nullable();
			$table->decimal('price', 10,2)->nullable();
			$table->timestamps();
			$table->timestamp('paid_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}