<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLunchesTable extends Migration {

	public function up()
	{
		Schema::create('lunches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned();
			$table->string('categ_ids', 255)->nullable();
			$table->enum('type_time', array('day', 'week', 'month'))->nullable();
			$table->boolean('vegan')->default(false);
			$table->boolean('gluten_free')->default(false);
			$table->boolean('has_take_away')->default(false);
			$table->boolean('has_eat_in')->default(true);
			$table->string('status', 25)->default('draft');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lunches');
	}
}