<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('country_id');
			$table->integer('city_id');
			$table->text('inclusions')->nullable();
			$table->text('exclusions');
			$table->double('duration', 8,2);
			$table->timestamps();
			$table->integer('vendor_id');
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}