<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricingSchemeTable extends Migration {

	public function up()
	{
		Schema::create('pricing_scheme', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('activity_id')->unsigned();
			$table->string('name');
			$table->integer('attr_id');
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('status')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pricing_scheme');
	}
}