<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model 
{

    protected $table = 'comment';
    public $timestamps = true;

    public function page()
    {
        return $this->belongsTo('App\Page');
    }

    public function child()
    {
        return $this->hasOne('App\Comment', 'parent');
    }

    public function parent()
    {
        return $this->belongsTo('App\Comment', 'id');
    }

}