<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Page extends Model 
{

    protected $table = 'page';
    public $timestamps = true;

    public function template()
    {
        return $this->belongsTo('App\Template');
    }

    public function page_type()
    {
        return $this->belongsTo('App\PageType');
    }

    public function parent()
    {
        return $this->belongsTo('Page', 'id');
    }

    public function childs()
    {
        return $this->hasMany('Page', 'page_id');
    }

    public function author()
    {
        return $this->belongsTo('App\User');
    }

    public function comments()
    {
        return $this->hasMany('App\Comment');
    }

    public function meta()
    {
        return $this->hasMany('App\PageMeta');
    }

    public function menu()
    {
        return $this->hasOne('App\Menu');
    }

    public function widgets()
    {
        return $this->hasMany('App\Widget');
    }

}