<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function LefSourceMapping()
	{
		return $this->hasMany('LefSourceMapping', 'client_id');
	}

	public function SourceChannelMappings()
	{
		return $this->hasMany('SourceChannelMapping', 'client_id');
	}

	public function Expenses()
	{
		return $this->hasMany('Expense', 'client_id');
	}

	public function LefSources()
	{
		return $this->hasMany('LefSource', 'client_id');
	}

	public function Source()
	{
		return $this->hasMany('Source', 'client_id');
	}

}