<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMahasiswaSarjanaTable extends Migration {

	public function up()
	{
		Schema::create('mahasiswa_sarjana', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nim', 100);
			$table->string('nama', 255);
			$table->string('email', 100);
			$table->string('hp', 20);
			$table->string('tempatlahir', 255);
			$table->date('tanggallahir');
			$table->enum('jeniskelamin', array(''));
			$table->string('namaayah');
			$table->string('namaibu');
			$table->string('photo');
			$table->integer('dosenpa')->unsigned()->nullable();
			$table->integer('tahunmasuk')->unsigned()->nullable();
			$table->integer('agama_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('mahasiswa_sarjana');
	}
}