<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->foreign('dosenpa')->references('id')->on('dosen')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->foreign('tahunmasuk')->references('id')->on('tahunakademik')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->foreign('agama_id')->references('id')->on('agama')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('matakuliah_sarjana', function(Blueprint $table) {
			$table->foreign('tipematakuliah_id')->references('id')->on('tipematakuliah')
						->onDelete('no action')
						->onUpdate('set null');
		});
		Schema::table('matakuliah_sarjana', function(Blueprint $table) {
			$table->foreign('sifatmatakuliah_id')->references('id')->on('sifatmatakuliah')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('kurikulum_matakuliah_sarjana', function(Blueprint $table) {
			$table->foreign('kurikulum_id')->references('id')->on('kurikulum_sarjana')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('kurikulum_matakuliah_sarjana', function(Blueprint $table) {
			$table->foreign('matakuliah_id')->references('id')->on('matakuliah_sarjana')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mahasiswa_profesi', function(Blueprint $table) {
			$table->foreign('mahasiswa_sarjana_id')->references('id')->on('mahasiswa_sarjana')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('matakuliah_profesi', function(Blueprint $table) {
			$table->foreign('departemen_id')->references('id')->on('departemen')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->foreign('mahasiswa_id')->references('id')->on('mahasiswa_sarjana')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->foreign('kurikulum_id')->references('id')->on('kurikulum_matakuliah_sarjana')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->foreign('hurufnilai_id')->references('id')->on('hurufnilai')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('kurikulum_profesi', function(Blueprint $table) {
			$table->foreign('tahunakademik_id')->references('id')->on('tahunakademik')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('blok_kurikulum', function(Blueprint $table) {
			$table->foreign('blok_matakuliah_id')->references('id')->on('blok_matakuliah')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blok_kurikulum', function(Blueprint $table) {
			$table->foreign('kurikulum_id')->references('id')->on('kurikulum_matakuliah_sarjana')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jadwal_blok', function(Blueprint $table) {
			$table->foreign('blok_matakuliah_id')->references('id')->on('blok_matakuliah')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dosen', function(Blueprint $table) {
			$table->foreign('golonganruang_id')->references('id')->on('golonganruang')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->dropForeign('mahasiswa_sarjana_dosenpa_foreign');
		});
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->dropForeign('mahasiswa_sarjana_tahunmasuk_foreign');
		});
		Schema::table('mahasiswa_sarjana', function(Blueprint $table) {
			$table->dropForeign('mahasiswa_sarjana_agama_id_foreign');
		});
		Schema::table('matakuliah_sarjana', function(Blueprint $table) {
			$table->dropForeign('matakuliah_sarjana_tipematakuliah_id_foreign');
		});
		Schema::table('matakuliah_sarjana', function(Blueprint $table) {
			$table->dropForeign('matakuliah_sarjana_sifatmatakuliah_id_foreign');
		});
		Schema::table('kurikulum_matakuliah_sarjana', function(Blueprint $table) {
			$table->dropForeign('kurikulum_matakuliah_sarjana_kurikulum_id_foreign');
		});
		Schema::table('kurikulum_matakuliah_sarjana', function(Blueprint $table) {
			$table->dropForeign('kurikulum_matakuliah_sarjana_matakuliah_id_foreign');
		});
		Schema::table('mahasiswa_profesi', function(Blueprint $table) {
			$table->dropForeign('mahasiswa_profesi_mahasiswa_sarjana_id_foreign');
		});
		Schema::table('matakuliah_profesi', function(Blueprint $table) {
			$table->dropForeign('matakuliah_profesi_departemen_id_foreign');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->dropForeign('rencanastudi_mahasiswa_id_foreign');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->dropForeign('rencanastudi_kurikulum_id_foreign');
		});
		Schema::table('rencanastudi', function(Blueprint $table) {
			$table->dropForeign('rencanastudi_hurufnilai_id_foreign');
		});
		Schema::table('kurikulum_profesi', function(Blueprint $table) {
			$table->dropForeign('kurikulum_profesi_tahunakademik_id_foreign');
		});
		Schema::table('blok_kurikulum', function(Blueprint $table) {
			$table->dropForeign('blok_kurikulum_blok_matakuliah_id_foreign');
		});
		Schema::table('blok_kurikulum', function(Blueprint $table) {
			$table->dropForeign('blok_kurikulum_kurikulum_id_foreign');
		});
		Schema::table('jadwal_blok', function(Blueprint $table) {
			$table->dropForeign('jadwal_blok_blok_matakuliah_id_foreign');
		});
		Schema::table('dosen', function(Blueprint $table) {
			$table->dropForeign('dosen_golonganruang_id_foreign');
		});
	}
}