<?php

namespace App\Models;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $guarded = array('governorate_id');
	protected $fillable = array('name');

	public function getGovernorate()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function getClients()
	{
		return $this->hasMany('App\Models\Client');
	}

	public function getDR()
	{
		return $this->hasMany('App\Models\DR');
	}

}