<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GraceHistory extends Model 
{

    protected $table = 'grace_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'company_id', 'date', 'period', 'order_id');

    public function company()
    {
        return $this->belongsTo('Company', 'company_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}