<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->integer('priority')->unsigned()->default('1');
			$table->bigInteger('node_id')->unsigned()->nullable();
			$table->string('url', 1000);
			$table->bigInteger('crawled_at')->nullable();
			$table->bigIncrements('website_id');
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}