<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNodesTable extends Migration {

	public function up()
	{
		Schema::create('nodes', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->integer('task_id');
			$table->string('title', 300);
			$table->text('description')->nullable();
			$table->string('image', 1000)->nullable();
			$table->timestamp('indexed_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('nodes');
	}
}