<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketersTable extends Migration {

	public function up()
	{
		Schema::create('marketers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('phone');
			$table->tinyInteger('gender');
			$table->string('brand');
			$table->tinyInteger('company_type');
			$table->string('industry');
			$table->string('email');
			$table->string('password');
			$table->string('promo_code')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('marketers');
	}
}