<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReadingsTable extends Migration {

	public function up()
	{
		Schema::create('readings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('transmitter_id')->unsigned();
			$table->integer('water_value')->default('0');
			$table->integer('battery_level')->default('0');
			$table->boolean('tamper_status')->default(false);
			$table->boolean('pair_status')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('readings');
	}
}